//=============================================================================
// File: SteamPhysicsComponents.h
// Desc: Bulk includes the various classes used by the steam engine physics.
//=============================================================================
#ifndef _SteamPhysicsComponents_H_
#define _SteamPhysicsComponents_H_
#pragma once



//=============================================================================
// Desc: Steam engine components namespace. Organises the components, and lets
//       us to use more succinct names without poluting the global namespace.
namespace SteamPhysics
{
  #define STEAMPHYSICS_MAX_PISTONS  10      // Maximum pistons that can be added
  #define RCONST                    8.3145  // Ideal gas constant.

};


#include "SteamPhysicsComponents/SteamPhysics_FireBox.h"
#include "SteamPhysicsComponents/SteamPhysics_Boiler.h"
#include "SteamPhysicsComponents/SteamPhysics_SteamChest.h"
#include "SteamPhysicsComponents/SteamPhysics_Piston.h"
#include "SteamPhysicsComponents/SteamPhysics_PistonManager.h"
#include "SteamPhysicsComponents/SteamPhysics_DrivingWheel.h"
#include "SteamPhysicsComponents/SteamPhysics_SafetyValve.h"


#endif // _SteamPhysicsComponents_H_

