//=============================================================================
// File: SteamPhysics_PistonManager.h
// Desc: Declares SteamPhysics::PistonManager, an object used to manage the
//       pistons (SteamPhysics::Piston) of a steam engine.
//=============================================================================
#ifndef _SteamPhysics_PistonManager_H_
#define _SteamPhysics_PistonManager_H_
#pragma once

#include "TNIPhysicsGlobals.h"


//=============================================================================
// Desc: Steam engine components namespace. Organises the components, and lets
//       us to use more succinct names without poluting the global namespace.
namespace SteamPhysics
{

class Piston;


//=============================================================================
// Name: PistonManager
// Desc: The piston manager is used to control steam flow from the steam chest
//       to the pistons, and from the pistons into the atmosphere.
//=============================================================================
class PistonManager
{
public:

  PistonManager(double valveLapPercent);

  void AddPiston(Piston* piston);

  void Update(SteamChest* steamChest, float dt, double cutoffSetting);


private:

  // The pistons referenced by this object (not owned here).
  Piston*     m_pistons[STEAMPHYSICS_MAX_PISTONS];
  int         m_pistonCount;

  double      m_specValveLapPercent;  // Controls steam escape to atmosphere

};


}; // namespace SteamPhysics


#endif // _SteamPhysics_PistonManager_H_