//=============================================================================
// File: TNIPhysicsVehicleState.h
// Desc: Declares the class used to track vehicle state between update calls.
//=============================================================================
#ifndef _TNIPhysicsVehicleState_H_
#define _TNIPhysicsVehicleState_H_
#pragma once

#include "trainznativeinterface.hpp"

class TNIPhysicsVehicle;
class VehicleBrakeData;
class TNIStream;
class TNISoup;


//=============================================================================
// Name: TNIPhysicsVehicleState
// Desc: Represents a single registered vehicle within the plugin. This is used
//       both as a place to store data related to that vehicle, and as way to
//       organise (and alter) code behaviour. As such, the update, save and
//       load functions are virtual, and may be altered based on whether this
//       is a steam or diesel/electric/unpowered traincar.
//=============================================================================
class TNIPhysicsVehicleState
{
public:

  TNIPhysicsVehicleState(const TNIPhysicsVehicle* vehicle);
  virtual ~TNIPhysicsVehicleState(void);

  const TNIRef<const TNIPhysicsVehicle>& GetVehicleRef(void) const { return m_vehicle; }
  const TNIPhysicsVehicle* GetVehicle(void) const { return m_vehicle.c_obj(); }

  virtual void UpdateEnginePhysics(float dt, VehicleBrakeData* brakeData, TNIRef<TNIStream>& io_resultsStream) { }

  virtual void SaveVehicleState(TNIRef<TNISoup>& io_data);
  virtual void LoadVehicleState(const TNIRef<const TNISoup>& data, int dataVersion);



  bool          m_bHasNotifiedSupportedFeatures = false;
  double        m_wheelMomentumPrev = 0;          // Previous frame momentum (DCC only).
  double        m_dccAvgLoad = 0;                 // Average engine load (DCC only, for accel/decel rate and PFX).
  int           m_brakeSettingAIOverride = -1;    // AI/script brake application (DCC only, -1 to disable).
  double        m_cachedWheelslipForce = 0;       // Current wheelslip force (non-DCC only).

protected:

  TNIRef<const TNIPhysicsVehicle> m_vehicle;      // The vehicle this state is for.

};


#endif // _TNIPhysicsVehicleState_H_

