//=============================================================================
// File: TrainPhysicsShared.h
// Desc: Declares a few shared train physics functions.
//=============================================================================
#ifndef _TrainPhysicsShared_H_
#define _TrainPhysicsShared_H_
#pragma once

#include "trainznativeinterface.hpp"

class TNIPhysicsVehicle;
class TNIPhysicsVehicleState;
class TNIStream;


bool IsStoppedDCCTrain(const TNIRef<const TNIPhysicsVehicle>& vehicle);


double DetermineResistanceForce(const TNIRef<const TNIPhysicsVehicle>& vehicle, TNIRef<TNIStream>& io_resultsStream);
double DetermineSlopeForce(const TNIRef<const TNIPhysicsVehicle>& vehicle, TNIRef<TNIStream>& io_resultsStream);
double DetermineBrakingForce(const TNIRef<const TNIPhysicsVehicle>& vehicle, TNIRef<TNIStream>& io_resultsStream);


void UpdateControlsStateInput(TNIPhysicsVehicleState* vehicleState,
                              const TNIRef<const TNIPhysicsVehicle>& frontCoupledVehicle,
                              const TNIRef<const TNIPhysicsVehicle>& backCoupledVehicle,
                              float dt, TNIRef<TNIStream>& io_resultsStream);



#endif // _TrainPhysicsShared_H_

