//=============================================================================
// File: UnitConversion.h
// Desc: Contains constants and static functions related to unit conversion.
//=============================================================================
#ifndef _UnitConversion_H_
#define _UnitConversion_H_
#pragma once


//=============================================================================
// Atmospheric pressure constants in various unit types.
static const double kAtmosphericPressurePSI = 14.69;
static const double kAtmosphericPressureGM3 = 14.69 * 0.0000703;
static const double kAtmosphericPressurePascals = 101325.01;


//=============================================================================
// Name: UnitConversion
// Desc: Static functions for various unit conversions used by this plugin. See
//       the function definitions for comments and sources (where relevant).
//=============================================================================
class UnitConversion
{
public:

  static double pa_psi(double pa);
  static double pa_bar(double pa);

  static double PSI_gm3(double psi);
  static double gm3_PSI(double gm3);
  static double APSI_gm3(double psi);
  static double gm3_APSI(double gm3);

  static double kpa_gm3(double kpa);
  static double gm3_kpa(double gm3);
  static double akpa_gm3(double akpa);
  static double gm3_akpa(double gm3);

  static double hg_kpa(double hg);

  static double in3_m3(double in3);
  static double f3_m3(double f3);
  static double l_m3(double l);

  static double kg_ton(double kg);
  static double ton_kg(double ton);

  static double mph_mps(double mph);
  static double mps_mph(double mps);
  static double kmh_mps(double mps);
  static double mps_kmh(double mps);

  static double lbf_kn(double lbf);
  static double kn_lbf(double kN);

};


#endif // _UnitConversion_H_

