//=============================================================================
// File: VehicleBrakeData.h
// Desc: Declares VehicleBrakeData, a small helper class to reduce code
//       duplication around brake system updates.
//=============================================================================
#ifndef _VehicleBrakeData_H_
#define _VehicleBrakeData_H_
#pragma once

#include "trainznativeinterface.hpp"
#include "Pneumatics.h"

class TNIPhysicsVehicle;


//=============================================================================
// Name: VehicleBrakeData
// Desc: Holds data describing a traincars brake systems. Created to aid with
//       readability in the brakes system update code. For example use see
//       UpdateControlsStateInput().
//=============================================================================
class VehicleBrakeData
{
public:

  VehicleBrakeData(const TNIPhysicsVehicle* veh);

  void WriteUpdateCommandsToStream(TNIRef<TNIStream>& io_resultsStream);

  const TNIPhysicsVehicle*  thisVeh;
  Pneumatic                 equaliser;
  Pneumatic                 mainReservoir;
  Pneumatic                 auxReservoir;
  Pneumatic                 autoBrakeCylinder;
  Pneumatic                 independentBrakeCylinder;

  #if ENABLE_VACUUM_BRAKES
    Pneumatic               vacuumReservoir;
    Pneumatic               vacuumBrakeCylinder;
  #endif // ENABLE_VACUUM_BRAKES
};


#endif // _VehicleBrakeData_H_

