//=============================================================================
// File: VehicleBrakePipeData.h
// Desc: Declares VehicleBrakePipeData, a small helper class to reduce code
//       duplication around brake system updates.
//=============================================================================
#ifndef _VehicleBrakePipeData_H_
#define _VehicleBrakePipeData_H_
#pragma once

#include "trainznativeinterface.hpp"
#include "Pneumatics.h"

class TNIPhysicsVehicle;


//=============================================================================
// Name: VehicleBrakePipeData
// Desc: Holds data describing a traincars brake pipes. This was created to
//       asist with the transfer of brake pressures to the front and rear
//       coupled vehicles, and perform shared init and result writing that
//       would otherwise need to be duplicated in the brakes update. For
//       example use see UpdateControlsStateInput().
//=============================================================================
class VehicleBrakePipeData
{
public:

  VehicleBrakePipeData(float brakePipeSpecPressure, const TNIPhysicsVehicle* veh);

  void WriteUpdateCommandsToStream(TNIRef<TNIStream>& io_resultsStream);

  const TNIPhysicsVehicle*  thisVeh;
  float                     pressureRatio;  // hack for coupling cars with different braking pressures
  Pneumatic                 trainBrakePipe;
  Pneumatic                 no3Pipe;
  Pneumatic                 no4Pipe;
  Pneumatic                 epReservoirPipe;

  #if ENABLE_VACUUM_BRAKES
    Pneumatic               vacuumBrakePipe;
  #endif // ENABLE_VACUUM_BRAKES

};


#endif // _VehicleBrakePipeData_H_

