// ============================================================================
// File: TNIBuffer.h
// Desc: A TNIBuffer ...
//=============================================================================
// File: TNIBuffer.h
//=============================================================================
#ifndef _TNIBUFFER_H
#define _TNIBUFFER_H
#pragma once

#include "trainznativeinterface.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus



//=============================================================================
// Name: TNIBuffer
// Desc: A static-sized data buffer
//=============================================================================
class TNIBuffer : public TNIObject
{
};



//=============================================================================
// Name: TNIAllocBuffer
// Desc: Allocates a new TNIBuffer object.
// Parm: copyFromData - If provided, this data will be copied into the buffer,
//       otherwise new uninitialised memory will be allocated.
// Parm: dataSize - The size (in bytes) of the buffer to allocate (must match
//       the size of the copyFromData if provided).
//=============================================================================
#if !TRAINZ_NATIVE_INTERFACE_CPP
TNIBuffer* TNIAllocBuffer(const char* copyFromData, size_t dataSize);
#endif // !TRAINZ_NATIVE_INTERFACE_CPP


//=============================================================================
// Name: TNIBufferGetPointer
// Desc: Returns a pointer to the internal buffer data.
//=============================================================================
#if !TRAINZ_NATIVE_INTERFACE_CPP
char* TNIBufferGetPointer(const TNIBuffer* buffer);
#endif // !TRAINZ_NATIVE_INTERFACE_CPP


//=============================================================================
// Name: TNIBufferGetByteLength
// Desc: Returns the size of this buffer in bytes.
//=============================================================================
#if !TRAINZ_NATIVE_INTERFACE_CPP
size_t TNIBufferGetByteLength(const TNIBuffer* buffer);
#endif // !TRAINZ_NATIVE_INTERFACE_CPP



//=============================================================================
// END COMPILER OPTIONS
//=============================================================================
#ifdef __cplusplus
}
#endif // __cplusplus

#endif  //  _TNIBUFFER_H
