//=============================================================================
// File: TNICPP.cpp
// Desc: This c++11 source file implements the c++11 wrappers for the language-
//       agnostic Trainz Native Interface APIs. These wrappers provide
//       additional safety features and syntactic sugar which aren't present in
//       raw API.
// Note: This file is NOT part of TrainzNativeInterface.DLL, but rather must be
//       included into any TNI plugin DLLs which use the TNI *.hpp files. The
//       symbols implemented here should not be exported from the DLL.
//=============================================================================

#if TRAINZ_NATIVE_INTERFACE_CPP
  #error inappropriate precompiled header active?
#endif // TRAINZ_NATIVE_INTERFACE_CPP

#define TRAINZ_NATIVE_INTERFACE_CPP 0
#include "trainznativeinterface.hpp"
#include "TNIFunctions.hpp"
#include "TNILabel.hpp"
#include "TNILibrary.hpp"
#include "TNIBuffer.h"
#include "TNIStream.hpp"
#include "TNIContext.hpp"
#include "TNIGameObjectID.hpp"
#include "TNIPhysics.hpp"
#include "TNIDebug.h"
#include "stdarg.h"



//=============================================================================
// CPP interface.
//=============================================================================
namespace TNI
{
  TNIRef<TNIString> TNIAllocString(const char* utf8text) { return TNIRef<TNIString>::Swallow(::TNIAllocString(utf8text)); }
  TNIRef<TNIInteger> TNIAllocInteger(int64_t value) { return TNIRef<TNIInteger>::Swallow(::TNIAllocInteger(value)); }
  int64_t TNIGetIntegerValue(TNIRefParam<const TNIObject> obj)
  {
    return ::TNIGetIntegerValue(obj.c_obj());
  }
  void TNISetIntegerValue(TNIRefParam<TNIInteger> obj, int64_t value)
  {
    return ::TNISetIntegerValue(obj.c_obj(), value);
  }
  TNIRef<TNIFloat> TNIAllocFloat(double value) { return TNIRef<TNIFloat>::Swallow(::TNIAllocFloat(value)); }
  double TNIGetFloatValue(TNIRefParam<const TNIObject> obj)
  {
    return ::TNIGetFloatValue(obj.c_obj());
  }
  void TNISetFloatValue(TNIRefParam<TNIFloat> obj, double value)
  {
    ::TNISetFloatValue(obj.c_obj(), value);
  }
  TNIRef<TNIAssetID> TNIAllocAssetID(uint32_t userID, uint32_t contentID, uint32_t version) { return TNIRef<TNIAssetID>::Swallow(::TNIAllocAssetID(userID, contentID, version)); }
  uint32_t TNIGetAssetIDUserID(TNIRefParam<const TNIAssetID> assetID)
  {
    return ::TNIGetAssetIDUserID(assetID.c_obj());
  }
  uint32_t TNIGetAssetIDContentID(TNIRefParam<const TNIAssetID> assetID)
  {
    return ::TNIGetAssetIDContentID(assetID.c_obj());
  }
  uint32_t TNIGetAssetIDVersion(TNIRefParam<const TNIAssetID> assetID)
  {
    return ::TNIGetAssetIDVersion(assetID.c_obj());
  }
  TNIRef<TNICoordinates> TNIAllocCoordinatesWorldCoordinates(int16_t h, int16_t v, float x, float y, float z) { return TNIRef<TNICoordinates>::Swallow(::TNIAllocCoordinatesWorldCoordinates(h, v, x, y, z)); }
  TNIRef<TNICoordinates> TNIAllocCoordinatesFloatingPoint(double x, double y, double z) { return TNIRef<TNICoordinates>::Swallow(::TNIAllocCoordinatesFloatingPoint(x, y, z)); }
  void TNICoordinatesSubtract(TNIRefParam<const TNICoordinates> lhs, TNIRefParam<const TNICoordinates> rhs, float* o_x, float* o_y, float* o_z)
  {
    return ::TNICoordinatesSubtract(lhs.c_obj(), rhs.c_obj(), o_x, o_y, o_z);
  }
  bool TNICoordinatesEquals(TNIRefParam<const TNICoordinates> lhs, TNIRefParam<const TNICoordinates> rhs)
  {
    return ::TNICoordinatesEquals(lhs.c_obj(), rhs.c_obj());
  }
  void TNICoordinatesGetWorldCoordinates(TNIRefParam<const TNICoordinates> coords, int16_t* o_h, int16_t* o_v, float* o_x, float* o_y, float* o_z)
  {
    return ::TNICoordinatesGetWorldCoordinates(coords.c_obj(), o_h, o_v, o_x, o_y, o_z);
  }
  void TNICoordinatesGetFloatingPoint(TNIRefParam<const TNICoordinates> coords, double* o_x, double* o_y, double* o_z)
  {
    return ::TNICoordinatesGetFloatingPoint(coords.c_obj(), o_x, o_y, o_z);
  }
  TNIRef<TNIArray> TNIAllocArray(size_t arraySize) { return TNIRef<TNIArray>::Swallow(::TNIAllocArray(arraySize)); }
  TNIRef<TNIObject> TNIGetArrayElement(TNIRefParam<const TNIObject> array, size_t arrayIndex) { return TNIRef<TNIObject>::Swallow(::TNIGetArrayElement(array, arrayIndex)); }
  void TNISetArraySize(TNIRefParam<TNIArray> array, size_t newArraySize)
  {
    ::TNISetArraySize(array.c_obj(), newArraySize);
  }
  size_t TNIGetArraySize(TNIRefParam<const TNIObject> array)
  {
    return ::TNIGetArraySize(array.c_obj());
  }
  void TNISetArrayElement(TNIRefParam<TNIArray> array, size_t arrayIndex, TNIRefParam<const TNIObject> value)
  {
    ::TNISetArrayElement(array.c_obj(), arrayIndex, value.c_obj());
  }
  TNIRef<TNISoup> TNIAllocSoup(void) { return TNIRef<TNISoup>::Swallow(::TNIAllocSoup()); }
  void TNISetSoupKeyValue(TNIRefParam<TNISoup> soup, TNIRefParam<const TNILabel> key, TNIRefParam<TNIObject> object)
  {
    return ::TNISetSoupKeyValue(soup, key, object);
  }
  size_t TNIGetSoupKeyCount(TNIRefParam<const TNISoup> soup)
  {
    return ::TNIGetSoupKeyCount(soup);
  }
  TNIRef<const TNIObject> TNIGetSoupValueByKey(TNIRefParam<const TNISoup> soup, TNIRefParam<const TNILabel> key) { return TNIRef<const TNIObject>::Swallow(::TNIGetSoupValueByKey(soup, key)); }
  TNIRef<const TNILabel> TNIGetSoupKeyByIndex(TNIRefParam<const TNISoup> soup, size_t index) { return TNIRef<const TNILabel>::Swallow(::TNIGetSoupKeyByIndex(soup, index)); }
  TNIRef<const TNIObject> TNIGetSoupValueByIndex(TNIRefParam<const TNISoup> soup, size_t index) { return TNIRef<const TNIObject>::Swallow(::TNIGetSoupValueByIndex(soup, index)); }
  TNIRef<TNIVector> TNIAllocVector(const float* elementData, size_t elementCount) { return TNIRef<TNIVector>::Swallow(::TNIAllocVector(elementData, elementCount)); }
  TNIRef<TNIHandle> TNIAllocHandle(TNIRefParam<TNIHandleTarget> target) { return TNIRef<TNIHandle>::Swallow(::TNIAllocHandle(target)); }

  TNIRef<const TNIString> TNICastString(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_STRING)
      return nullptr;
    
    return TNIRef<TNIString>::Reference((TNIString*)object.c_obj());
  }
  
  TNIRef<const TNIInteger> TNICastInteger(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_INTEGER)
      return nullptr;
    
    return TNIRef<TNIInteger>::Reference((TNIInteger*)object.c_obj());
  }
  
  TNIRef<const TNIFloat> TNICastFloat(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_FLOAT)
      return nullptr;
    
    return TNIRef<TNIFloat>::Reference((TNIFloat*)object.c_obj());
  }
  
  TNIRef<const TNIAssetID> TNICastAssetID(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_ASSETID)
      return nullptr;
    
    return TNIRef<TNIAssetID>::Reference((TNIAssetID*)object.c_obj());
  }
  
  TNIRef<const TNIArray> TNICastArray(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_ARRAY)
      return nullptr;
    
    return TNIRef<TNIArray>::Reference((TNIArray*)object.c_obj());
  }
  
  TNIRef<const TNIVector> TNICastVector(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_VECTOR)
      return nullptr;
    
    return TNIRef<TNIVector>::Reference((TNIVector*)object.c_obj());
  }
  
  TNIRef<const TNISoup> TNICastSoup(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_SOUP)
      return nullptr;
    
    return TNIRef<TNISoup>::Reference((TNISoup*)object.c_obj());
  }
  
  TNIRef<const TNILibrary> TNICastLibrary(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_LIBRARY)
      return nullptr;
    
    return TNIRef<TNILibrary>::Reference((TNILibrary*)object.c_obj());
  }
  
  TNIRef<const TNILabel> TNICastLabel(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_LABEL)
      return nullptr;
    
    return TNIRef<TNILabel>::Reference((TNILabel*)object.c_obj());
  }
  
  TNIRef<const TNICoordinates> TNICastCoordinates(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_COORDINATES)
      return nullptr;
    
    return TNIRef<TNICoordinates>::Reference((TNICoordinates*)object.c_obj());
  }
  
  TNIRef<const TNIHandle> TNICastHandle(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_HANDLE)
      return nullptr;
    
    return TNIRef<TNIHandle>::Reference((TNIHandle*)object.c_obj());
  }
  
  TNIRef<const TNIBuffer> TNICastBuffer(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_BUFFER)
      return nullptr;
    
    return TNIRef<TNIBuffer>::Reference((TNIBuffer*)object.c_obj());
  }
  
  TNIRef<const TNIGameObjectID> TNICastGameObjectID(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_GAME_OBJECT_ID)
      return nullptr;
    
    return TNIRef<TNIGameObjectID>::Reference((TNIGameObjectID*)object.c_obj());
  }
  
  TNIRef<TNIInteger> TNICastMutableInteger(const TNIRef<const TNIObject>& object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_INTEGER)
      return nullptr;
    
    return TNIRef<TNIInteger>::Reference((TNIInteger*)object.c_obj());
  }
  
  TNIRef<TNIFloat> TNICastMutableFloat(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_FLOAT)
      return nullptr;
    
    return TNIRef<TNIFloat>::Reference((TNIFloat*)object.c_obj());
  }
  
  TNIRef<TNIArray> TNICastMutableArray(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_ARRAY)
      return nullptr;
    
    return TNIRef<TNIArray>::Reference((TNIArray*)object.c_obj());
  }
  
  TNIRef<TNIStream> TNICastMutableStream(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (TNIGetObjectClass(object.c_obj()) != TNI_CLASS_STREAM)
      return nullptr;
    
    return TNIRef<TNIStream>::Reference((TNIStream*)object.c_obj());
  }

  const TNIRef<const TNIPhysicsVehicle> TNICastPhysicsVehicle(const TNIRef<const TNIObject>& object)
  {
    if (!object || TNIGetObjectClass(object) != TNI_CLASS_PHYSICS_VEHICLE)
      return nullptr;

    return TNIRef<const TNIPhysicsVehicle>::Reference((const TNIPhysicsVehicle*)object.c_obj());
  }


  TNIRef<TNIArray> TNIAllocArrayWith1(TNIRefParam<const TNIObject> object0) { return TNIRef<TNIArray>::Swallow(::TNIAllocArrayWith1(object0)); }
  TNIRef<TNIArray> TNIAllocArrayWith2(TNIRefParam<const TNIObject> object0, TNIRefParam<const TNIObject> object1) { return TNIRef<TNIArray>::Swallow(::TNIAllocArrayWith2(object0, object1)); }
  TNIRef<TNIArray> TNIAllocArrayWith3(TNIRefParam<const TNIObject> object0, TNIRefParam<const TNIObject> object1, TNIRefParam<const TNIObject> object2) { return TNIRef<TNIArray>::Swallow(::TNIAllocArrayWith3(object0, object1, object2)); }
  TNIRef<TNIArray> TNIAllocArrayWith4(TNIRefParam<const TNIObject> object0, TNIRefParam<const TNIObject> object1, TNIRefParam<const TNIObject> object2, TNIRefParam<const TNIObject> object3) { return TNIRef<TNIArray>::Swallow(::TNIAllocArrayWith4(object0, object1, object2, object3)); }
  TNIRef<TNIArray> TNIAllocArrayWith5(TNIRefParam<const TNIObject> object0, TNIRefParam<const TNIObject> object1, TNIRefParam<const TNIObject> object2, TNIRefParam<const TNIObject> object3, TNIRefParam<const TNIObject> object4) { return TNIRef<TNIArray>::Swallow(::TNIAllocArrayWith5(object0, object1, object2, object3, object4)); }
  TNIRef<TNIArray> TNIAllocArrayWith6(TNIRefParam<const TNIObject> object0, TNIRefParam<const TNIObject> object1, TNIRefParam<const TNIObject> object2, TNIRefParam<const TNIObject> object3, TNIRefParam<const TNIObject> object4, TNIRefParam<const TNIObject> object5) { return TNIRef<TNIArray>::Swallow(::TNIAllocArrayWith6(object0, object1, object2, object3, object4, object5)); }

  TNIRef<TNIString> TNIAllocStringWithIntegerValue(int number) { return TNIRef<TNIString>::Swallow(::TNIAllocStringWithIntegerValue(number)); }
  
  int TNIGetStringIntegerValue(TNIRefParam<const TNIObject> string, int failureSignal)
  {
    return ::TNIGetStringIntegerValue(string.c_obj(), failureSignal);
  }
  
  
  TNIRef<TNIStream> TNIAllocStream(uint32_t bufferLen, uint32_t autoResizeAmount)
  {
    return TNISwallowReference(::TNIAllocStream(bufferLen, autoResizeAmount));
  }
  TNIRef<TNIStream> TNIAllocCustomStream(const TNIStreamInitData& streamInitData)
  {
    return TNISwallowReference(::TNIAllocCustomStream(streamInitData));
  }
  void TNICloseCustomStream(TNIRefParam<TNIStream> stream)
  {
    ::TNICloseCustomStream(stream.c_obj());
  }
  TNIRef<TNIObject> TNISerialiseFromStream(TNIRefParam<TNIContext> context, TNIRefParam<TNIStream> srcStream, TNIObject* (*helperCallback)(TNIContext* context, int32_t objectClass, TNIStream* srcStream))
  {
    return TNISwallowReference(::TNISerialiseFromStream(context, srcStream, helperCallback));
  }
  TNIRef<TNIString> TNIStreamReadString(TNIRefParam<TNIStream> stream)
  {
    return TNISwallowReference(::TNIStreamReadString(stream));
  }
  TNIRef<TNIAssetID> TNIStreamReadAssetID(TNIRefParam<TNIStream> stream)
  {
    return TNISwallowReference(::TNIStreamReadAssetID(stream));
  }
  TNIRef<const TNIObject> TNIStreamRetrieveObjectReference(TNIRefParam<TNIStream> stream, int32_t object)
  {
    return TNISwallowReference(::TNIStreamRetrieveObjectReference(stream, object));
  }
  TNIRef<const TNIObject> TNIStreamReadTNIObjectReference(TNIRefParam<TNIStream> stream)
  {
    return TNISwallowReference(::TNIStreamReadTNIObjectReference(stream));
  }
  
  /*TNIRef<const TNIStream> TNICastStream(TNIRefParam<const TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (::TNIGetObjectClass(object) != TNI_CLASS_STREAM)
      return nullptr;
    
    return TNIRef<const TNIStream>::Reference((const TNIStream*)object.c_obj());
  }*/
  TNIRef<TNIStream> TNICastStream(TNIRefParam<TNIObject> object)
  {
    if (!object)
      return nullptr;
    
    if (::TNIGetObjectClass(object) != TNI_CLASS_STREAM)
      return nullptr;
    
    return TNIRef<TNIStream>::Reference((TNIStream*)object.c_obj());
  }
  
  TNIRef<TNILabel> TNIAllocLabel(const char* utf8text)
  {
    return TNISwallowReference(::TNIAllocLabel(utf8text));
  }

  const char* TNIGetLabelDebugText(TNIRefParam<const TNIObject> label)
  {
    return ::TNIGetLabelDebugText(label.c_obj());
  }
  
  TNIRef<TNILibrary> TNIAllocLibrary(TNIRefParam<TNIContext> context, TNIRefParam<const TNILabel> libraryName, const TNILibraryInitData& libraryInitData)
  {
    return TNISwallowReference(::TNIAllocLibrary(context, libraryName, libraryInitData));
  }
  
  TNIRef<const TNIAssetID> TNIGetLibraryAsset(TNIRefParam<const TNILibrary> library)
  {
    return TNISwallowReference(::TNIGetLibraryAsset(library));
  }
  
  TNIRef<const TNISoup> TNIGetLibraryConfigSoup(TNIRefParam<const TNILibrary> library)
  {
    return TNISwallowReference(::TNIGetLibraryConfigSoup(library));
  }
  
  TNIRef<TNIObject> TNICallLibraryFunction(TNIRefParam<const TNILibrary> library, TNIRefParam<const TNILabel> functionName, TNIRefParam<const TNIObject> params)
  {
    return TNISwallowReference(::TNICallLibraryFunction(library, functionName, params));
  }
  
  TNIRef<TNILibrary> TNIGetContextLibrary(TNIRefParam<const TNIContext> context, TNIRefParam<const TNILabel> libraryName)
  {
    return TNISwallowReference(::TNIGetContextLibrary(context, libraryName));
  }

  const char* TNIGetStringText(TNIRefParam<const TNIObject> string)
  {
    return ::TNIGetStringText(string.c_obj());
  }

  uint32_t TNIGetObjectClass(TNIRefParam<const TNIObject> object)
  {
    return ::TNIGetObjectClass(object.c_obj());
  }

  void TNILog(TNIRefParam<const TNIContext> context, const char* textStringUTF8)
  {
    ::TNILog(context.c_obj(), textStringUTF8);
  }
  void TNILogObject(TNIRefParam<const TNIContext> context, TNIRefParam<const TNIObject> object, size_t indentLevel)
  {
    ::TNILogObject(context.c_obj(), object.c_obj(), indentLevel);
  }
  void TNILogf(TNIRefParam<const TNIContext> context, const char* formatStringUTF8, ...)
  {
    va_list arg;
    va_start(arg, formatStringUTF8);
    ::TNILogv(context.c_obj(), formatStringUTF8, arg);
    va_end(arg);
  }
  void TNILogv(TNIRefParam<const TNIContext> context, const char* formatStringUTF8, va_list argv)
  {
    ::TNILogv(context.c_obj(), formatStringUTF8, argv);
  }

  TNIRef<TNIBuffer> TNIAllocBuffer(const char* copyFromData, size_t dataSize)
  {
    return TNISwallowReference(::TNIAllocBuffer(copyFromData, dataSize));
  }
  char* TNIBufferGetPointer(TNIRefParam<const TNIBuffer> buffer)
  {
    return ::TNIBufferGetPointer(buffer.c_obj());
  }
  size_t TNIBufferGetByteLength(TNIRefParam<const TNIBuffer> buffer)
  {
    return ::TNIBufferGetByteLength(buffer.c_obj());
  }
  uint32_t TNIGetLibraryVersion(TNIRefParam<const TNILibrary> library)
  {
    return ::TNIGetLibraryVersion(library.c_obj());
  }






  
  bool TNISerialiseToStream(TNIRefParam<TNIContext> context, TNIRefParam<const TNIObject> srcObject, TNIRefParam<TNIStream> dstStream, bool (*helperCallback)(TNIContext* context, const TNIObject* object, TNIStream* dstStream))
  {
    return ::TNISerialiseToStream(context.c_obj(), srcObject.c_obj(), dstStream.c_obj(), helperCallback);
  }

  void TNIStreamResize(TNIRefParam<TNIStream> stream, uint32_t newLen)
  {
    return ::TNIStreamResize(stream.c_obj(), newLen);
  }

  bool TNIStreamSeek(TNIRefParam<TNIStream> stream, uint32_t pos)
  {
    return ::TNIStreamSeek(stream.c_obj(), pos);
  }

  bool TNIStreamSeekFromEnd(TNIRefParam<TNIStream> stream, uint32_t pos)
  {
    return ::TNIStreamSeekFromEnd(stream.c_obj(), pos);
  }

  size_t TNIStreamTell(TNIRefParam<TNIStream> stream)
  {
    return ::TNIStreamTell(stream.c_obj());
  }

  size_t TNIStreamGetSize(TNIRefParam<TNIStream> stream)
  {
    return ::TNIStreamGetSize(stream.c_obj());
  }

  bool TNIStreamCopy(TNIRefParam<TNIStream> dstStream, TNIRefParam<TNIStream> srcStream, size_t copyLength)
  {
    return ::TNIStreamCopy(dstStream.c_obj(), srcStream.c_obj(), copyLength);
  }

  bool TNIStreamWriteFloat(TNIRefParam<TNIStream> stream, float value)
  {
    return ::TNIStreamWriteFloat(stream, value);
  }
  bool TNIStreamWriteFloatArray(TNIRefParam<TNIStream> stream, const float value[], int count)
  {
    return ::TNIStreamWriteFloatArray(stream, value, count);
  }

  bool TNIStreamWriteFloat64(TNIRefParam<TNIStream> stream, double value)
  {
    return ::TNIStreamWriteFloat64(stream, value);
  }
  bool TNIStreamWriteFloat64Array(TNIRefParam<TNIStream> stream, const double value[], int count)
  {
    return ::TNIStreamWriteFloat64Array(stream, value, count);
  }

  bool TNIStreamWriteInt64(TNIRefParam<TNIStream> stream, int64_t value)
  {
    return ::TNIStreamWriteInt64(stream, value);
  }
  bool TNIStreamWriteInt64Array(TNIStream* stream, const int64_t value[], int count)
  {
    return ::TNIStreamWriteInt64Array(stream, value, count);
  }

  bool TNIStreamWriteInt32(TNIRefParam<TNIStream> stream, int32_t value)
  {
    return ::TNIStreamWriteInt32(stream, value);
  }
  bool TNIStreamWriteInt32Array(TNIRefParam<TNIStream> stream, const int32_t value[], int count)
  {
    return ::TNIStreamWriteInt32Array(stream, value, count);
  }

  bool TNIStreamWriteInt16(TNIRefParam<TNIStream> stream, int16_t value)
  {
    return ::TNIStreamWriteInt16(stream, value);
  }
  bool TNIStreamWriteInt16Array(TNIRefParam<TNIStream> stream, const int16_t value[], int count)
  {
    return ::TNIStreamWriteInt16Array(stream, value, count);
  }

  bool TNIStreamWriteInt8(TNIRefParam<TNIStream> stream, int8_t value)
  {
    return ::TNIStreamWriteInt8(stream, value);
  }
  bool TNIStreamWriteInt8Array(TNIRefParam<TNIStream> stream, const int8_t value[], int count)
  {
    return ::TNIStreamWriteInt8Array(stream, value, count);
  }

  bool TNIStreamWriteString(TNIRefParam<TNIStream> stream, TNIRefParam<const TNIString> string)
  {
    return ::TNIStreamWriteString(stream, string);
  }

  bool TNIStreamWriteAssetID(TNIRefParam<TNIStream> stream, TNIRefParam<const TNIAssetID> assetId)
  {
    return ::TNIStreamWriteAssetID(stream, assetId);
  }

  int32_t TNIStreamStoreObjectReference(TNIRefParam<TNIStream> stream, TNIRefParam<const TNIObject> object)
  {
    return ::TNIStreamStoreObjectReference(stream, object);
  }
  bool TNIStreamWriteTNIObjectReference(TNIRefParam<TNIStream> stream, TNIRefParam<const TNIObject> object)
  {
    return ::TNIStreamWriteTNIObjectReference(stream, object);
  }

  float TNIStreamReadFloat(TNIRefParam<TNIStream> stream, float failureSignal)
  {
    return ::TNIStreamReadFloat(stream, failureSignal);
  }
  bool TNIStreamReadFloatArray(TNIRefParam<TNIStream> stream, float value[], int count)
  {
    return ::TNIStreamReadFloatArray(stream, value, count);
  }

  double TNIStreamReadFloat64(TNIRefParam<TNIStream> stream, double failureSignal)
  {
    return ::TNIStreamReadFloat64(stream, failureSignal);
  }
  bool TNIStreamReadFloat64Array(TNIRefParam<TNIStream> stream, double value[], int count)
  {
    return ::TNIStreamReadFloat64Array(stream, value, count);
  }

  int64_t TNIStreamReadInt64(TNIRefParam<TNIStream> stream, int64_t failureSignal)
  {
    return ::TNIStreamReadInt64(stream, failureSignal);
  }
  bool TNIStreamReadInt64Array(TNIRefParam<TNIStream> stream, int64_t value[], int count)
  {
    return ::TNIStreamReadInt64Array(stream, value, count);
  }

  int32_t TNIStreamReadInt32(TNIRefParam<TNIStream> stream, int32_t failureSignal)
  {
    return ::TNIStreamReadInt32(stream, failureSignal);
  }
  bool TNIStreamReadInt32Array(TNIRefParam<TNIStream> stream, int32_t value[], int count)
  {
    return ::TNIStreamReadInt32Array(stream, value, count);
  }

  int16_t TNIStreamReadInt16(TNIRefParam<TNIStream> stream, int16_t failureSignal)
  {
    return ::TNIStreamReadInt16(stream, failureSignal);
  }
  bool TNIStreamReadInt16Array(TNIRefParam<TNIStream> stream, int16_t value[], int count)
  {
    return ::TNIStreamReadInt16Array(stream, value, count);
  }

  int8_t TNIStreamReadInt8(TNIRefParam<TNIStream> stream, int8_t failureSignal)
  {
    return ::TNIStreamReadInt8(stream, failureSignal);
  }
  bool TNIStreamReadInt8Array(TNIRefParam<TNIStream> stream, int8_t value[], int count)
  {
    return ::TNIStreamReadInt8Array(stream, value, count);
  }


  //=============================================================================
  // TNIGameObjectID accessors
  TNIRef<const TNIString> TNIGetGameObjectIDDebugString(TNIRef<const TNIGameObjectID> id)
  {
    return TNIRef<const TNIString>::Swallow(::TNIGetGameObjectIDDebugString(id.c_obj()));
  }


  //=============================================================================
  // TNIPhysicsVehicle GameObjectID accessors
  const TNIRef<const TNIGameObjectID> TNIPhysicsGetVehicleID(TNIRef<const TNIPhysicsVehicle> vehicle)
  {
    return TNIRef<const TNIGameObjectID>::Reference(::TNIPhysicsGetVehicleID(vehicle.c_obj()));
  }
  const TNIRef<const TNIGameObjectID> TNIPhysicsGetVehicleTrainID(TNIRef<const TNIPhysicsVehicle> vehicle)
  {
    return TNIRef<const TNIGameObjectID>::Reference(::TNIPhysicsGetVehicleTrainID(vehicle.c_obj()));
  }
  bool TNIPhysicsDoesVehicleMatchID(TNIRef<const TNIPhysicsVehicle> vehicle, TNIRef<const TNIGameObjectID> id)
  {
    return TNIPhysicsDoesVehicleMatchID(vehicle.c_obj(), id.c_obj());
  }


  //=============================================================================
  // TNIPhysicsVehicle AssetID/config accessors
  TNIRef<const TNIAssetID> TNIPhysicsGetVehicleAssetID(const TNIRef<const TNIPhysicsVehicle>& vehicle)
  {
    return TNIRef<const TNIAssetID>::Reference(::TNIPhysicsGetVehicleAssetID(vehicle.c_obj()));
  }
  TNIRef<const TNISoup> TNIPhysicsGetVehicleAssetConfig(const TNIRef<const TNIPhysicsVehicle>& vehicle)
  {
    return TNIRef<const TNISoup>::Reference(::TNIPhysicsGetVehicleAssetConfig(vehicle.c_obj()));
  }
  TNIRef<const TNIAssetID> TNIPhysicsGetVehicleEngineAssetID(const TNIRef<const TNIPhysicsVehicle>& vehicle)
  {
    return TNIRef<const TNIAssetID>::Reference(::TNIPhysicsGetVehicleEngineAssetID(vehicle.c_obj()));
  }
  TNIRef<const TNISoup> TNIPhysicsGetVehicleEngineAssetConfig(const TNIRef<const TNIPhysicsVehicle>& vehicle)
  {
    return TNIRef<const TNISoup>::Reference(::TNIPhysicsGetVehicleEngineAssetConfig(vehicle.c_obj()));
  }
  TNIRef<const TNIAssetID> TNIPhysicsGetVehicleTrackAssetID(const TNIRef<const TNIPhysicsVehicle>& vehicle)
  {
    return TNIRef<const TNIAssetID>::Reference(::TNIPhysicsGetVehicleTrackAssetID(vehicle.c_obj()));
  }
  TNIRef<const TNISoup> TNIPhysicsGetVehicleTrackAssetConfig(const TNIRef<const TNIPhysicsVehicle>& vehicle)
  {
    return TNIRef<const TNISoup>::Reference(::TNIPhysicsGetVehicleTrackAssetConfig(vehicle.c_obj()));
  }

};

