// ============================================================================
// File: TNIContext.h
// Desc: The TNIContext is passed into the third-party DLL on initial load,
//       and is a required parameter for some accessor functions.
// ============================================================================
#ifndef _TNICONTEXT_H
#define _TNICONTEXT_H
#pragma once

#include "trainznativeinterface.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus



// ============================================================================
// Name: TNIContext
// Desc: 
// ============================================================================
class TNIContext final : public TNIObject
{
public:

protected:
  friend void TNIRelease(const TNIObject* object);

  TNIContext(void);
  ~TNIContext(void);

};



// ============================================================================
// ACCESSOR FUNCTIONS
// ============================================================================



// ============================================================================
// Name: TNIGetContextVersionCode
// Desc: Returns the Trainz Version code for this context.
// Parm: context - The context to query.
// Retn: uint32_t - The version code.
// ============================================================================
uint32_t TNIGetContextVersionCode(const TNIContext* context);



// ============================================================================
// Name: TNIGetContextLibrary
// Desc: Looks up a library in the specified context by name.
// Parm: context - The context to query.
// Parm: libraryName - The unique name of the library to return.
// Retn: TNILibrary* - The located library object, or NULL on failure.
// ============================================================================
#if !TRAINZ_NATIVE_INTERFACE_CPP
TNILibrary* TNIGetContextLibrary(const TNIContext* context, const TNILabel* libraryName);
#endif // !TRAINZ_NATIVE_INTERFACE_CPP




// ============================================================================
// END COMPILER OPTIONS
// ============================================================================
#ifdef __cplusplus
}
#endif // __cplusplus

#endif // _TNICONTEXT_H
