//=============================================================================
// File: TNIDialog.cpp
// Desc: . 
//=============================================================================
#include "TNIDialog.h"
#include <mutex>

static std::mutex s_initMutex;

TNIRef<const TNILabel> g_TNIDialog_libraryLabel = nullptr;

TNIRef<const TNILabel> g_TNIDialog_newDialog_functionLabel = nullptr;
TNIRef<const TNILabel> g_TNIDialog_closeDialog_functionLabel = nullptr;
TNIRef<const TNILabel> g_TNIDialog_click_callbackLabel = nullptr;
TNIRef<const TNILabel> g_TNIDialog_textEnter_callbackLabel = nullptr;
TNIRef<const TNILabel> g_TNIDialog_textChanged_callbackLabel = nullptr;
TNIRef<const TNILabel> g_TNIDialog_dialogClosed_callbackLabel = nullptr;
TNIRef<const TNILabel> g_TNIDialog_getControlText_functionLabel = nullptr;
TNIRef<const TNILabel> g_TNIDialog_setControlText_functionLabel = nullptr;



//=============================================================================
// Name: TNIDialog_InitHelpers
// Desc: This function must be called at least once before any other 
//       functionality from this helper file is used. This function is thread-
//       safe and is harmless to call more than once.
//=============================================================================
void TNIDialog_InitHelpers(void)
{
  s_initMutex.lock();
  
  if (!g_TNIDialog_libraryLabel)
  {
    g_TNIDialog_libraryLabel = TNIAllocLabel("TNIDialog");
    
    g_TNIDialog_newDialog_functionLabel = TNIAllocLabel("TNIDialog::NewDialog");
    g_TNIDialog_closeDialog_functionLabel = TNIAllocLabel("TNIDialog::CloseDialog");
    g_TNIDialog_click_callbackLabel = TNIAllocLabel("TNIDialog::click-callback");
    g_TNIDialog_textEnter_callbackLabel = TNIAllocLabel("TNIDialog::enter-keypress-callback");
    g_TNIDialog_textChanged_callbackLabel = TNIAllocLabel("TNIDialog::text-changed-callback");
    g_TNIDialog_dialogClosed_callbackLabel = TNIAllocLabel("TNIDialog::dialog-closed");
    g_TNIDialog_getControlText_functionLabel = TNIAllocLabel("TNIDialog::get-control-text");
    g_TNIDialog_setControlText_functionLabel = TNIAllocLabel("TNIDialog::set-control-text");
  }
  
  s_initMutex.unlock();
}
