//=============================================================================
// File: TNIDialog.h
// Desc: Provides helper functions for accessing user interface functionality
//       from C++ TNI plugins.
// Note: This file is a prototype, and the interfaces can be expected to change
//       in a breaking fashion prior to final release. 
//=============================================================================
#ifndef _TNIDIALOG_H
#define _TNIDIALOG_H
#pragma once

#include "trainznativeinterface.hpp"
#include "TNIFunctions.hpp"
#include "TNILibrary.hpp"
#include "TNILabel.hpp"
#include <vector>


//=============================================================================
// Usage note: the C++ helper functions defined here simply place TNI library 
// calls to the underlying TNIDialog library. It is perfectly legal to call 
// the library directly, but more verbose and less documented.
//=============================================================================


//=============================================================================
// Name: TNIDialog_InitHelpers
// Desc: This function must be called at least once before any other 
//       functionality from this helper file is used. This function is thread-
//       safe and is harmless to call more than once.
//=============================================================================
void TNIDialog_InitHelpers(void);



//=============================================================================
// TNIDialog Library label.
//=============================================================================
extern TNIRef<const TNILabel> g_TNIDialog_libraryLabel;


//=============================================================================
// TNIDialog Function labels.
//=============================================================================
extern TNIRef<const TNILabel> g_TNIDialog_newDialog_functionLabel;
extern TNIRef<const TNILabel> g_TNIDialog_closeDialog_functionLabel;
extern TNIRef<const TNILabel> g_TNIDialog_getControlText_functionLabel;
extern TNIRef<const TNILabel> g_TNIDialog_setControlText_functionLabel;

//=============================================================================
// TNIDialog Callback labels.
//=============================================================================
extern TNIRef<const TNILabel> g_TNIDialog_click_callbackLabel;
extern TNIRef<const TNILabel> g_TNIDialog_textEnter_callbackLabel;
extern TNIRef<const TNILabel> g_TNIDialog_textChanged_callbackLabel;
extern TNIRef<const TNILabel> g_TNIDialog_dialogClosed_callbackLabel;




//=============================================================================
// Name: TNIDialog_NewDialog
// Desc: .
// Parm: .
// Parm: .
//=============================================================================
inline TNIRef<const TNIHandle> TNIDialog_NewDialog(
    TNIRefParam<TNILibrary> tniDialogLibrary
  , TNIRefParam<const TNIAssetID> assetID
  , TNIRefParam<const TNIString> userInterfaceFilepath
  , TNIRefParam<const TNILibrary> optionalCallbackLibrary
  )
{
  TNIRef<TNIArray> _params = TNIAllocArrayWith3(assetID, userInterfaceFilepath, optionalCallbackLibrary);
  
  return TNICastHandle(TNICallLibraryFunction(tniDialogLibrary, g_TNIDialog_newDialog_functionLabel.c_obj(), _params.c_obj()));
}


//=============================================================================
// Name: TNIDialog_CloseDialog
// Desc: .
// Parm: .
// Parm: .
//=============================================================================
inline void TNIDialog_CloseDialog(
    TNIRefParam<TNILibrary> tniDialogLibrary
  , TNIRefParam<const TNIHandle> dialog
  )
{
  TNIRef<TNIArray> _params = TNIAllocArrayWith1(dialog);
  
  TNICallLibraryFunction(tniDialogLibrary, g_TNIDialog_closeDialog_functionLabel.c_obj(), _params.c_obj());
}


//=============================================================================
// Name: TNIDialog_GetControlText
// Desc: .
// Parm: .
// Parm: .
//=============================================================================
inline TNIRef<const TNIString> TNIDialog_GetControlText(
    TNIRefParam<TNILibrary> tniDialogLibrary
  , TNIRefParam<const TNIHandle> dialog
  , TNIRefParam<const TNILabel> control
  )
{
  TNIRef<TNIArray> _params = TNIAllocArrayWith2(dialog, control);
  
  return TNICastString(TNICallLibraryFunction(tniDialogLibrary, g_TNIDialog_getControlText_functionLabel, _params));
}


//=============================================================================
// Name: TNIDialog_SetControlText
// Desc: .
// Parm: .
// Parm: .
//=============================================================================
inline void TNIDialog_SetControlText(
    TNIRefParam<TNILibrary> tniDialogLibrary
  , TNIRefParam<const TNIHandle> dialog
  , TNIRefParam<const TNILabel> control
  , TNIRefParam<const TNIString> text
  )
{
  TNIRef<TNIArray> _params = TNIAllocArrayWith3(dialog, control, text);
  
  TNICallLibraryFunction(tniDialogLibrary, g_TNIDialog_setControlText_functionLabel, _params);
}
 


#endif // _TNIDIALOG_H
