//=============================================================================
// File: TNIGameObjectID.h
// Desc: Declares TNIGameObjectID, which is used to identify Trainz game
//       objects such as trains, script libraries, etc.
//=============================================================================
#ifndef _TNIGAMEOBJECTID_H
#define _TNIGAMEOBJECTID_H
#pragma once

#include "trainznativeinterface.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus



//=============================================================================
// Name: TNIGameObjectID
// Desc: 
//=============================================================================
class TNIGameObjectID : public TNIObject
{
};



//=============================================================================
// Name: TNIGetGameObjectIDDebugString
// Desc: Builds a TNIString containing debug info for a TNIGameObjectID. The
//       resulting string can be used for debug logging or similar, but code
//       should not attempt to machine parse it or similar, as the format may
//       change without notice.
// Parm: id - The ID to build the debug string for
// Retn: TNIString* - A newly allocated TNIString containing debug info for
//       this ID, suitable for logging etc. The caller must release this string
//       when they are done with it.
//=============================================================================
const TNIString* TNIGetGameObjectIDDebugString(const TNIGameObjectID* id);


//=============================================================================
// Name: TNIDoGameObjectIDsMatch
// Desc: Compares the internal data of two TNIGameObjectIDs and returns whether
//       they refer to the same object.
//=============================================================================
bool TNIDoGameObjectIDsMatch(const TNIGameObjectID* a, const TNIGameObjectID* b);



//=============================================================================
// END COMPILER OPTIONS
//=============================================================================
#ifdef __cplusplus
}
#endif // __cplusplus




#endif  //  _TNIGAMEOBJECTID_H
