// ============================================================================
// File: TNILabel.h
// Desc: A TNILabel is a unique identifier which is 1:1 mapped to a string
//       constant. It is not intended to replace TNIString as a string storage
//       facility, but instead allows a string to be mapped to an internal
//       identifier which can be used as an efficient key to various internal
//       data structures.
// ============================================================================
#ifndef _TNILABEL_H
#define _TNILABEL_H
#pragma once

#include "trainznativeinterface.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus





// ============================================================================
// Name: TNILabel
// Desc: 
// ============================================================================
class TNILabel : public TNIObject
{
};


// ============================================================================
// Name: TNIAllocLabel
// Desc: Returns a label object for the specified text. Only one label object
//       can exist for a given label at any time- repeated calls to this
//       function with the same text string will result in the same object
//       being returned (although the refcount is increased with each call.)
//       It is safe to rely on this property, so you can directly compare the
//       returned pointer for equality or inequality.
//       This is a relatively slow function; you should call it once to
//       generate the label, then store the label for as long as you need to
//       use it. You should not attempt to regenerate the same label for each
//       usage.
// Parm: utf8text - The text which corresponds to the label. A null or empty
//       string will result in a nullptr label; this is not considered an
//       error.
// ============================================================================
#if !TRAINZ_NATIVE_INTERFACE_CPP
TNILabel* TNIAllocLabel(const char* utf8text);
#endif // !TRAINZ_NATIVE_INTERFACE_CPP



// ============================================================================
// Name: TNIGetLabelDebugText
// Desc: Returns a string representation of the label, for debugging purposes.
//       Note that there is no guarantee that this representation matches the
//       string passed to TNIAllocLabel, and it should not be machine parsed.
// Parm: label - The label to query.
// Retn: const char* - A utf8-encoded string representing the label for the
//       purposes of debug logging. The returned string is not owned by the
//       caller but references a buffer internal to the label object.
//       If 'label' is nullptr, the result will be the empty string.
// ============================================================================
const char* TNIGetLabelDebugText(const TNIObject* label);







//=============================================================================
// END COMPILER OPTIONS
//=============================================================================
#ifdef __cplusplus
}
#endif // __cplusplus




#endif  //  _TNILABEL_H
