// ============================================================================
// File: TNILabel.hpp
// Desc: A TNILabel is a unique identifier which is 1:1 mapped to a string
//       constant. It is not intended to replace TNIString as a string storage
//       facility, but instead allows a string to be mapped to an internal
//       identifier which can be used as an efficient key to various internal
//       data structures.
// ============================================================================
#ifndef _TNILABEL_HPP
#define _TNILABEL_HPP
#pragma once

#include "trainznativeinterface.hpp"
#include "TNILabel.h"


//=============================================================================
// CPP interface.
//=============================================================================
namespace TNI
{
  TNIRef<TNILabel> TNIAllocLabel(const char* utf8text);
  const char* TNIGetLabelDebugText(TNIRefParam<const TNIObject> label);
};
using namespace TNI;


#endif // _TNILABEL_HPP
