// ============================================================================
// File: TNILibrary.hpp
// Desc: A TNILibrary is roughly equivalent to a trainzscript "Library" class.
//       A third-party DLL should return a new TNILibrary instance from the
//       initial entry-point call, to open a communication channel between
//       Trainz and the third-party DLL.
// ============================================================================
#ifndef _TNILIBRARY_HPP
#define _TNILIBRARY_HPP
#pragma once

#include "trainznativeinterface.hpp"
#include "TNILibrary.h"


//=============================================================================
// CPP interface.
//=============================================================================
namespace TNI
{
  TNIRef<TNILibrary> TNIAllocLibrary(TNIRefParam<TNIContext> context, TNIRefParam<const TNILabel> libraryName, const TNILibraryInitData& libraryInitData);
  TNIRef<const TNIAssetID> TNIGetLibraryAsset(TNIRefParam<const TNILibrary> library);
  TNIRef<const TNISoup> TNIGetLibraryConfigSoup(TNIRefParam<const TNILibrary> library);
  TNIRef<TNIObject> TNICallLibraryFunction(TNIRefParam<const TNILibrary> library, TNIRefParam<const TNILabel> functionName, TNIRefParam<const TNIObject> params);
};
using namespace TNI;


#endif // _TNILIBRARY_H
