//=============================================================================
// File: TNIPhysics.hpp
// Desc: Declares the TNI physics associated classes, enums and functions.
//=============================================================================
#ifndef _TNIPhysics_HPP_
#define _TNIPhysics_HPP_
#pragma once

#include "trainznativeinterface.hpp"
#include "TNIPhysics.h"


//=============================================================================
// CPP interface.
//=============================================================================
namespace TNI
{
  //===========================================================================
  const TNIRef<const TNIPhysicsVehicle> TNICastPhysicsVehicle(const TNIRef<const TNIObject>& object);


  const TNIRef<const TNIGameObjectID> TNIPhysicsGetVehicleID(TNIRef<const TNIPhysicsVehicle> vehicle);
  const TNIRef<const TNIGameObjectID> TNIPhysicsGetVehicleTrainID(TNIRef<const TNIPhysicsVehicle> vehicle);
  bool TNIPhysicsDoesVehicleMatchID(TNIRef<const TNIPhysicsVehicle> vehicle, TNIRef<const TNIGameObjectID> id);


  // TNIPhysicsVehicle AssetID/config accessors
  TNIRef<const TNIAssetID> TNIPhysicsGetVehicleAssetID(const TNIRef<const TNIPhysicsVehicle>& vehicle);
  TNIRef<const TNISoup> TNIPhysicsGetVehicleAssetConfig(const TNIRef<const TNIPhysicsVehicle>& vehicle);
  TNIRef<const TNIAssetID> TNIPhysicsGetVehicleEngineAssetID(const TNIRef<const TNIPhysicsVehicle>& vehicle);
  TNIRef<const TNISoup> TNIPhysicsGetVehicleEngineAssetConfig(const TNIRef<const TNIPhysicsVehicle>& vehicle);
  TNIRef<const TNIAssetID> TNIPhysicsGetVehicleTrackAssetID(const TNIRef<const TNIPhysicsVehicle>& vehicle);
  TNIRef<const TNISoup> TNIPhysicsGetVehicleTrackAssetConfig(const TNIRef<const TNIPhysicsVehicle>& vehicle);


};
using namespace TNI;


#endif  //  _TNIPhysics_HPP_

