//=============================================================================
// File: TNIStream.hpp
// Desc: Declares a data stream class for use in TNI libraries.
//=============================================================================
#ifndef _TNISTREAM_HPP_
#define _TNISTREAM_HPP_
#pragma once

#include "trainznativeinterface.hpp"
#include "TNIStream.h"


//=============================================================================
// CPP interface.
//=============================================================================
namespace TNI
{
  TNIRef<TNIStream> TNIAllocStream(uint32_t bufferLen, uint32_t autoResizeAmount = 0);
  TNIRef<TNIStream> TNIAllocCustomStream(const TNIStreamInitData& streamInitData);
  void TNICloseCustomStream(TNIRefParam<TNIStream> stream);
  TNIRef<TNIObject> TNISerialiseFromStream(TNIRefParam<TNIContext> context, TNIRefParam<TNIStream> srcStream, TNIObject* (*helperCallback)(TNIContext* context, int32_t objectClass, TNIStream* srcStream) = nullptr);
  TNIRef<TNIString> TNIStreamReadString(TNIRefParam<TNIStream> stream);
  TNIRef<TNIAssetID> TNIStreamReadAssetID(TNIRefParam<TNIStream> stream);
  TNIRef<const TNIObject> TNIStreamRetrieveObjectReference(TNIRefParam<TNIStream> stream, int32_t object);
  TNIRef<const TNIObject> TNIStreamReadTNIObjectReference(TNIRefParam<TNIStream> stream);
  
  //TNIRef<const TNIStream> TNICastStream(TNIRefParam<const TNIObject> object);
  TNIRef<TNIStream> TNICastStream(TNIRefParam<TNIObject> object);


  bool TNISerialiseToStream(TNIRefParam<TNIContext> context, TNIRefParam<const TNIObject> srcObject, TNIRefParam<TNIStream> dstStream, bool (*helperCallback)(TNIContext* context, const TNIObject* object, TNIStream* dstStream) = NULL);

  void TNIStreamResize(TNIRefParam<TNIStream> stream, uint32_t newLen);

  bool TNIStreamSeek(TNIRefParam<TNIStream> stream, uint32_t pos);
  bool TNIStreamSeekFromEnd(TNIRefParam<TNIStream> stream, uint32_t pos);

  size_t TNIStreamTell(TNIRefParam<TNIStream> stream);

  size_t TNIStreamGetSize(TNIRefParam<TNIStream> stream);

  bool TNIStreamCopy(TNIRefParam<TNIStream> dstStream, TNIRefParam<TNIStream> srcStream, size_t copyLength);

  bool TNIStreamWriteFloat(TNIRefParam<TNIStream> stream, float value);
  bool TNIStreamWriteFloatArray(TNIRefParam<TNIStream> stream, const float value[], int count);

  bool TNIStreamWriteFloat64(TNIRefParam<TNIStream> stream, double value);
  bool TNIStreamWriteFloat64Array(TNIRefParam<TNIStream> stream, const double value[], int count);

  bool TNIStreamWriteInt64(TNIRefParam<TNIStream> stream, int64_t value);
  bool TNIStreamWriteInt64Array(TNIStream* stream, const int64_t value[], int count);

  bool TNIStreamWriteInt32(TNIRefParam<TNIStream> stream, int32_t value);
  bool TNIStreamWriteInt32Array(TNIRefParam<TNIStream> stream, const int32_t value[], int count);

  bool TNIStreamWriteInt16(TNIRefParam<TNIStream> stream, int16_t value);
  bool TNIStreamWriteInt16Array(TNIRefParam<TNIStream> stream, const int16_t value[], int count);

  bool TNIStreamWriteInt8(TNIRefParam<TNIStream> stream, int8_t value);
  bool TNIStreamWriteInt8Array(TNIRefParam<TNIStream> stream, const int8_t value[], int count);

  bool TNIStreamWriteString(TNIRefParam<TNIStream> stream, TNIRefParam<const TNIString> string);

  bool TNIStreamWriteAssetID(TNIRefParam<TNIStream> stream, TNIRefParam<const TNIAssetID> assetId);

  int32_t TNIStreamStoreObjectReference(TNIRefParam<TNIStream> stream, TNIRefParam<const TNIObject> object);
  bool TNIStreamWriteTNIObjectReference(TNIRefParam<TNIStream> stream, TNIRefParam<const TNIObject> object);

  float TNIStreamReadFloat(TNIRefParam<TNIStream> stream, float failureSignal = -1.f);
  bool TNIStreamReadFloatArray(TNIRefParam<TNIStream> stream, float value[], int count);

  double TNIStreamReadFloat64(TNIRefParam<TNIStream> stream, double failureSignal = -1.0);
  bool TNIStreamReadFloat64Array(TNIRefParam<TNIStream> stream, double value[], int count);

  int64_t TNIStreamReadInt64(TNIRefParam<TNIStream> stream, int64_t failureSignal = -1);
  bool TNIStreamReadInt64Array(TNIRefParam<TNIStream> stream, int64_t value[], int count);

  int32_t TNIStreamReadInt32(TNIRefParam<TNIStream> stream, int32_t failureSignal = -1);
  bool TNIStreamReadInt32Array(TNIRefParam<TNIStream> stream, int32_t value[], int count);

  int16_t TNIStreamReadInt16(TNIRefParam<TNIStream> stream, int16_t failureSignal = -1);
  bool TNIStreamReadInt16Array(TNIRefParam<TNIStream> stream, int16_t value[], int count);

  int8_t TNIStreamReadInt8(TNIRefParam<TNIStream> stream, int8_t failureSignal = -1);
  bool TNIStreamReadInt8Array(TNIRefParam<TNIStream> stream, int8_t value[], int count);

};
using namespace TNI;

#endif  //  _TNISTREAM_HPP_
